#!/bin/sh -e

path=$(pwd)
cp_config="all"
if [ ! -d /mnt/upgrade ];
then
	mkdir /mnt/upgrade
fi

if [ -e /usr/bin/ctrl_bd ]; then
ret=`cat /usr/bin/ctrl_bd | grep "XILINX" | wc -l`
else
ret=0
fi

if [ $ret -eq 1 ];then
    cd ./xilinx
	
	if [ -e BOOT.bin ]; then
        flash_erase /dev/mtd0 0x0 0x80 >/dev/null 2>&1
        nandwrite -p -s 0x0 /dev/mtd0 ./BOOT.bin >/dev/null 2>&1
        rm -rf BOOT.bin
    fi

    if [ -e bmminer.sh ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./bmminer.sh /etc/init.d
    fi
	
	if [ -e bmminer ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./bmminer /usr/bin
    fi
	
	if [ -e minerConfiguration.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./minerConfiguration.cgi /www/pages/cgi-bin
    fi
	
	if [ -e minerConfiguration2.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./minerConfiguration2.cgi /www/pages/cgi-bin
    fi
    	
	if [ -e minerStatus.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./minerStatus.cgi /www/pages/cgi-bin
    fi
    	
	if [ -e set_miner_conf.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./set_miner_conf.cgi /www/pages/cgi-bin
    fi
    	
	if [ -e Efficiency.html ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./Efficiency.html /www/pages/cgi-bin
    fi

	if [ -e get_config.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./get_config.cgi /www/pages/cgi-bin
    fi

	if [ -e cascade.css ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./cascade.css /www/pages/css
    fi

	if [ -e antminer_logo.png ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./antminer_logo.png /www/pages/images
    fi

	if [ -e get_freq_logs.cgi ]; then
        /etc/init.d/bmminer.sh stop > /dev/null 2>&1
		cp ./get_freq_logs.cgi /www/pages/cgi-bin
    fi
	
	sync
	
	echo "Nov 11 - 2018 ( Contact: discord.gg/JdQJ77X or Telegram Djay Firmwares )" > /usr/bin/compile_time
	echo "Antminer S9 DjayOS " >> /usr/bin/compile_time
	echo "Asic Boost" >> /usr/bin/compile_time
	
 
else
	echo "This is not supported on C5 control board yet!"
fi
 
rm -rf *.tar.gz


#/sbin/reboot -f &
